function layout()
return {

modifiers = {
['LShift'] = 'LShift',
['RShift'] = 'RShift',
['LAlt'] = 'LAlt',
['RAlt'] = 'RAlt',
['LCtrl'] = 'LCtrl',
['RCtrl'] = 'RCtrl',
['LWin'] = 'LWin',
['RWin'] = 'RWin',
},

keyCommands = {

-- Temporary
{combos = {{key = 'X', reformers = {'LShift', 'LCtrl'}}}, down = iCommandViewExplosion, name = 'Explosion', category = 'Cheat'},

-- Gameplay
{combos = {{key = '`'}}, down = ICommandToggleConsole, name = 'Toggle Console', category = 'Debug'},
{combos = {{key = 'Esc'}}, down = iCommandQuit, name = 'End mission', category = 'General'},
{combos = {{key = 'Pause'}}, down = iCommandBrakeGo, name = 'Pause', category = 'General'},
--{combos = {{key = 'Pause', reformers = {'RShift', 'RWin'}}}, down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'General'},
{combos = {{key = 'Z', reformers = {'LCtrl'}}}, down = iCommandAccelerate, name = 'Time accelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LAlt'}}}, down = iCommandDecelerate, name = 'Time decelerate', category = 'General'},
{combos = {{key = 'Z', reformers = {'LShift'}}}, down = iCommandNoAcceleration, name = 'Time normal', category = 'General'},
{combos = {{key = '\''}}, down = iCommandScoresWindowToggle, name = 'Score window', category = 'General'},
{combos = {{key = '\'', reformers = {'RShift'}}}, down = iCommandDebriefing, name = 'Show debriefing window', category = 'General'},
--{combos = {{key = 'Tab', reformers = {'LShift'}}}, down = iCommandTrkEsc, name = 'Playback track cancel', category = 'General'},
--{combos = {{key = 'Scroll', reformers = {'RShift', 'RCtrl'}}}, down = iCommandRecordCursorOnOff, name = 'Record of mouse cursor in track On/Off', category = 'General'},
--{combos = {{key = 'S', reformers = {'LCtrl'}}}, down = iCommandSoundMicOn, name = 'Sound recording begin', category = 'General'},
--{combos = {{key = 'S', reformers = {'LAlt'}}}, down = iCommandSoundMicOff, name = 'Sound recording end', category = 'General'},
--{combos = {{key = 'E', reformers = {'RShift', 'RCtrl'}}}, down = iCommandTrackEditReplace, name = 'Track edit replace mode', category = 'General'},
--{combos = {{key = 'W', reformers = {'RShift', 'RCtrl'}}}, down = iCommandTrackEditInsert, name = 'Track edit insert mode', category = 'General'},
{combos = {{key = 'Tab'}}, 									down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl'}}}, down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{combos = {{key = 'Y', reformers = {'LCtrl'}}}, down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
--{combos = {{key = 'Scroll', reformers = {'RShift'}}}, down = iCommandRecordSubtitleOn, name = 'Subtitle recording begin', category = 'General'},
--{combos = {{key = 'Scroll', reformers = {'RCtrl'}}}, down = iCommandRecordSubtitleOff, name = 'Subtitle recording end', category = 'General'},
{combos = {{key = 'Tab', reformers = {'RCtrl', 'RShift'}}}, down = iCommandRecoverHuman, name = 'Get new plane - respawn', category = 'General'},
--{combos = {{key = 'U'}}, down = iCommandPlaneShipTakeOff, name = 'Ship Take Off Position', category = 'General'},
--{combos = {{key = 'J', reformers = {'RAlt'}}}, down = iCommandPlaneJump, name = 'Jump into other aircraft', category = 'General'},
{combos = {{key = 'SysRQ'}}, down = iCommandScreenShot, name = 'Screenshot', category = 'General'},
--{combos = {{key = 'Pause', reformers = {'RShift'}}}, down = iCommandOneFrame, name = 'One frame mode', category = 'General'},
{combos = {{key = 'Pause', reformers = {'RCtrl'}}}, down = iCommandGraphicsFrameRate, name = 'Frame rate counter - Service info', category = 'General'},
{combos = {{key = 'Y', reformers = {'LAlt'}}}, down = iCommandViewCoordinatesInLinearUnits, name = 'Coordinates units change', category = 'General'},

--[[
--Flight Control

{combos = {{key = 'Up'}}, down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = 'Nose Down', category = 'Flight Control'},
{combos = {{key = 'Down'}}, down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = 'Nose Up', category = 'Flight Control'},
{combos = {{key = 'Left'}}, down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = 'Bank Left', category = 'Flight Control'},
{combos = {{key = 'Right'}}, down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = 'Bank Right', category = 'Flight Control'},
{combos = {{key = 'Z'}}, down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = 'Rudder Left', category = 'Flight Control'},
{combos = {{key = 'X'}}, down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = 'Rudder Right', category = 'Flight Control'},

{combos = {{key = 'Up', reformers = {'RCtrl'}}}, down = iCommandPlaneUp, name = 'Plane Down', category = 'Flight Control'},
{combos = {{key = 'Down', reformers = {'RCtrl'}}}, down = iCommandPlaneDown, name = 'Plane Up', category = 'Flight Control'},
{combos = {{key = 'Left', reformers = {'RCtrl'}}}, down = iCommandPlaneLeft, name = 'Plane Left', category = 'Flight Control'},
{combos = {{key = 'Right', reformers = {'RCtrl'}}}, down = iCommandPlaneRight, name = 'Plane Right', category = 'Flight Control'},

{combos = {{key = '.', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = 'Trim Up', category = 'Flight Control'},
{combos = {{key = ';', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = 'Trim Down', category = 'Flight Control'},
{combos = {{key = ',', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = 'Trim Left', category = 'Flight Control'},
{combos = {{key = '/', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = 'Trim Right', category = 'Flight Control'},
{combos = {{key = 'Z', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = 'Trim Left Rudder', category = 'Flight Control'},
{combos = {{key = 'X', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = 'Trim Right Rudder', category = 'Flight Control'},
{combos = {{key = 'T', reformers = {'RCtrl'}}}, down = iCommandPlaneTrimCancel, name = 'Reset Trimmers', category = 'Flight Control'},

{combos = {{key = 'Num+'}}, pressed = iCommandPlaneAUTIncrease, name = 'Power Up', category = 'Flight Control'},
{combos = {{key = 'Num-'}}, pressed = iCommandPlaneAUTDecrease, name = 'Power Down', category = 'Flight Control'},
{combos = {{key = 'PageUp'}}, down = iCommandPlaneAUTIncreaseRegime, name = 'Thrust Up', category = 'Flight Control'},
{combos = {{key = 'PageDown'}}, down = iCommandPlaneAUTDecreaseRegime, name = 'Thrust Down', category = 'Flight Control'},

{combos = {{key = 'Num+', reformers = {'RAlt'}}}, pressed = iCommandPlaneAUTIncreaseLeft, name = 'Power Up Left', category = 'Flight Control'},
{combos = {{key = 'Num-', reformers = {'RAlt'}}}, pressed = iCommandPlaneAUTDecreaseLeft, name = 'Power Down Left', category = 'Flight Control'},
{combos = {{key = 'PageUp', reformers = {'RAlt'}}}, down = iCommandPlaneAUTIncreaseRegimeLeft, name = 'Thrust Up Left', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RAlt'}}}, down = iCommandPlaneAUTDecreaseRegimeLeft, name = 'Thrust Down Left', category = 'Flight Control'},

{combos = {{key = 'Num+', reformers = {'RShift'}}}, pressed = iCommandPlaneAUTIncreaseRight, name = 'Power Up Right', category = 'Flight Control'},
{combos = {{key = 'Num-', reformers = {'RShift'}}}, pressed = iCommandPlaneAUTDecreaseRight, name = 'Power Down Right', category = 'Flight Control'},
{combos = {{key = 'PageUp', reformers = {'RShift'}}}, down = iCommandPlaneAUTIncreaseRegimeRight, name = 'Thrust Up Right', category = 'Flight Control'},
{combos = {{key = 'PageDown', reformers = {'RShift'}}}, down = iCommandPlaneAUTDecreaseRegimeRight, name = 'Thrust Down Right', category = 'Flight Control'},
{combos = {{key = 'K'}}, down = iCommandPlaneCobra, name = 'Execute Pugachev\'s Cobra', category = 'Flight Control'},

-- Autopilot
{combos = {{key = 'A'}}, down = iCommandPlaneAutopilot, name = 'Toggle Autopilot', category = 'Autopilot'},
{combos = {{key = 'J'}}, down = iCommandPlaneAUTOnOff, name = 'Toggle Autothrust', category = 'Autopilot'},
{combos = {{key = 'H'}}, down = iCommandPlaneSAUHBarometric, name = 'Autopilot - Barometric Altitude Hold', category = 'Autopilot'},
{combos = {{key = '`', reformers = {'LAlt'}}}, down = iCommandPlaneAutopilotOverrideOn, up = iCommandPlaneAutopilotOverrideOff, name = 'Autopilot override (Su-25T)', category = 'Autopilot'},
{combos = {{key = '1', reformers = {'LAlt'}}}, down = iCommandPlaneStabTangBank, name = 'Autopilot - Attitude Hold', category = 'Autopilot'},
{combos = {{key = '2', reformers = {'LAlt'}}}, down = iCommandPlaneStabHbarBank, name = 'Autopilot - Altitude And Roll Hold', category = 'Autopilot'},
{combos = {{key = '3', reformers = {'LAlt'}}}, down = iCommandPlaneStabHorizon, name = 'Autopilot - Transition To Level Flight Control', category = 'Autopilot'},
{combos = {{key = '4', reformers = {'LAlt'}}}, down = iCommandPlaneStabHbar, name = 'Autopilot - Barometric Altitude Hold', category = 'Autopilot'},
{combos = {{key = '5', reformers = {'LAlt'}}}, down = iCommandPlaneStabHrad, name = 'Autopilot - Radar Altitude Hold', category = 'Autopilot'},
{combos = {{key = '6', reformers = {'LAlt'}}}, down = iCommandPlaneRouteAutopilot, name = 'Autopilot - \'Route following\'', category = 'Autopilot'},
{combos = {{key = '9', reformers = {'LAlt'}}}, down = iCommandPlaneStabCancel, name = 'Autopilot Disengage', category = 'Autopilot'},

-- Systems
{combos = {{key = 'B'}}, down = iCommandPlaneAirBrake, name = 'Toggle Airbrake', category = 'Systems'},
{combos = {{key = 'B', reformers = {'LShift'}}}, down = iCommandPlaneAirBrakeOn, name = 'Airbrake Out', category = 'Systems'},
{combos = {{key = 'B', reformers = {'LCtrl'}}}, down = iCommandPlaneAirBrakeOff, name = 'Airbrake In', category = 'Systems'},
{combos = {{key = 'R'}}, down = iCommandPlaneFuelOn, up = iCommandPlaneFuelOff, name = 'Begin Refuel', category = 'Systems'},
{combos = {{key = 'R', reformers = {'LCtrl'}}}, down = iCommandPlaneAirRefuel, name = 'Toggle Refueling Boom', category = 'Systems'},
{combos = {{key = 'R', reformers = {'LAlt'}}}, down = iCommandPlaneJettisonFuelTanks, name = 'Jettison Fuel Tanks', category = 'Systems'},
{combos = {{key = 'T'}}, down = iCommandPlaneWingtipSmokeOnOff, name = 'Toggle Smoke', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RShift'}}}, down = iCommandPowerOnOff, name = 'Power Switch Su-25T', category = 'Systems'},
{combos = {{key = 'L'}}, down = iCommandPlaneCockpitIllumination, name = 'Cockpit Illumination', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RCtrl'}}}, down = iCommandPlaneLightsOnOff, name = 'Toggle Navigation lights', category = 'Systems'},
{combos = {{key = 'L', reformers = {'RAlt'}}}, down = iCommandPlaneHeadLightOnOff, name = 'Toggle Gear Light Near/Far/Off', category = 'Systems'},
{combos = {{key = 'F'}}, down = iCommandPlaneFlaps, name = 'Toggle Flaps Up/Down', category = 'Systems'},
{combos = {{key = 'F', reformers = {'LShift'}}}, down = iCommandPlaneFlapsOn, name = 'Flaps Down To The Landing Position', category = 'Systems'},
{combos = {{key = 'F', reformers = {'LCtrl'}}}, down = iCommandPlaneFlapsOff, name = 'Flaps Up', category = 'Systems'},
{combos = {{key = 'G'}}, down = iCommandPlaneGear, name = 'Toggle Landing Gear Up/Down', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LCtrl'}}}, down = iCommandPlaneGearUp, name = 'Toggle Landing Gear Up', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LShift'}}}, down = iCommandPlaneGearDown, name = 'Toggle Landing Gear Down', category = 'Systems'},
{combos = {{key = 'W'}}, down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = 'Wheel Brake On', category = 'Systems'},
{combos = {{key = 'G', reformers = {'LAlt'}}}, down = iCommandPlaneHook, name = 'Toggle Arrestor Hook', category = 'Systems'},
{combos = {{key = 'P', reformers = {'RCtrl'}}}, down = iCommandPlanePackWing, name = 'Toggle Folding Wings', category = 'Systems'},
{combos = {{key = 'C', reformers = {'LCtrl'}}}, down = iCommandPlaneFonar, name = 'Canopy Open/Close', category = 'Systems'},
{combos = {{key = 'P'}}, down = iCommandPlaneParachute, name = 'Release Drogue Chute', category = 'Systems'},
{combos = {{key = 'N', reformers = {'RShift'}}}, down = iCommandPlaneResetMasterWarning, name = 'Reset Current Audible Warning', category = 'Systems'},
{combos = {{key = 'W', reformers = {'LCtrl'}}}, down = iCommandPlaneJettisonWeapons, name = 'Jettison Weapons', category = 'Systems'},
{combos = {{key = 'E', reformers = {'LCtrl'}}}, down = iCommandPlaneEject, name = 'Eject', category = 'Systems'},
{combos = {{key = 'C', reformers = {'RWin'}}}, down = iCommandFlightClockReset, name = 'Start/Stop/Reset Flight Clock', category = 'Systems'},
{combos = {{key = '=', reformers = {'RShift'}}}, pressed = iCommandAltimeterPressureIncrease,   up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Increase Su-25T', category = 'Systems'},
{combos = {{key = '-', reformers = {'RShift'}}}, pressed = iCommandAltimeterPressureDecrease, up = iCommandAltimeterPressureStop, name = 'Altimeter Pressure Decrease Su-25T', category = 'Systems'},
{combos = {{key = 'Home', reformers = {'RWin'}}}, down = iCommandEnginesStart, name = 'Engines Start', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RWin'}}}, down = iCommandEnginesStop, name = 'Engines Stop', category = 'Systems'},
{combos = {{key = 'Home', reformers = {'RAlt'}}}, down = iCommandLeftEngineStart, name = 'Left Engine Start', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RAlt'}}}, down = iCommandLeftEngineStop, name = 'Left Engine Stop', category = 'Systems'},
{combos = {{key = 'Home', reformers = {'RCtrl'}}}, down = iCommandRightEngineStart, name = 'Right Engine Start', category = 'Systems'},
{combos = {{key = 'End', reformers = {'RCtrl'}}}, down = iCommandRightEngineStop, name = 'Right Engine Stop', category = 'Systems'},
{combos = {{key = 'H', reformers = {'RCtrl'}}}, down = iCommandBrightnessILS, name = 'HUD Color', category = 'Systems'},

-- Modes
{combos = {{key = '`'}}, down = iCommandPlaneChangeTarget, name = '(`) Select Next Waypoint, Airfield Or Target', category = 'Modes'},
{combos = {{key = '1'}}, down = iCommandPlaneModeNAV, name = '(1) Navigation Modes', category = 'Modes'},
{combos = {{key = '2'}}, down = iCommandPlaneModeBVR, name = '(2) Beyond Visual Range Mode', category = 'Modes'},
{combos = {{key = '3'}}, down = iCommandPlaneModeVS, name = '(3) Close Air Combat Vertical Scan Mode', category = 'Modes'},
{combos = {{key = '4'}}, down = iCommandPlaneModeBore, name = '(4) Close Air Combat Bore Mode', category = 'Modes'},
{combos = {{key = '5'}}, down = iCommandPlaneModeHelmet, name = '(5) Close Air Combat HMD Helmet Mode', category = 'Modes'},
{combos = {{key = '6'}}, down = iCommandPlaneModeFI0, name = '(6) Longitudinal Missile Aiming Mode', category = 'Modes'},
{combos = {{key = '7'}}, down = iCommandPlaneModeGround, name = '(7) Air-To-Ground Mode', category = 'Modes'},
{combos = {{key = '8'}}, down = iCommandPlaneModeGrid, name = '(8) Gunsight Grid Switch', category = 'Modes'},

-- Sensors
--{combos = {{key = 'Tab'}}, down = iCommandPlaneChangeLock, name = 'Lock Target', category = 'Sensors'},
{combos = {{key = 'Tab'}}, down = iCommandPlane_LockOn_start, up = iCommandPlane_LockOn_finish, name = 'Lock Target', category = 'Sensors'},
{combos = {{key = 'Tab', reformers = {'LCtrl'}}}, down = iCommandRefusalTWS, name = 'Unlock Target', category = 'Sensors'},
{combos = {{key = 'I'}}, down = iCommandPlaneRadarOnOff, name = 'Toggle Radar On/Off', category = 'Sensors'},
{combos = {{key = 'I', reformers = {'RAlt'}}}, down = iCommandPlaneRadarChangeMode, name = 'Change Radar Mode RWS/TWS', category = 'Sensors'},
{combos = {{key = 'I', reformers = {'RCtrl'}}}, down = iCommandPlaneRadarCenter, name = 'Target Designator To Center', category = 'Sensors'},
{combos = {{key = 'I', reformers = {'RWin'}}}, down = iCommandPlaneChangeRadarPRF, name = 'Change Radar Pulse Repeat Frequency ', category = 'Sensors'},
{combos = {{key = 'O'}}, down = iCommandPlaneEOSOnOff, name = 'Toggle Electro-Optical System On/Off', category = 'Sensors'},
{combos = {{key = 'O', reformers = {'RShift'}}}, down = iCommandPlaneLaserRangerOnOff, name = 'Toggle Laser Ranger On/Off', category = 'Sensors'},
{combos = {{key = 'O', reformers = {'RCtrl'}}}, down = iCommandPlaneNightTVOnOff, name = 'Toggle Night Channel (FLIR or LLTV) On/Off', category = 'Sensors'},
{combos = {{key = ';'}}, pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = 'Target Designator Up', category = 'Sensors'},
{combos = {{key = '.'}}, pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = 'Target Designator Down', category = 'Sensors'},
{combos = {{key = ','}}, pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = 'Target Designator Left', category = 'Sensors'},
{combos = {{key = '/'}}, pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = 'Target Designator Right', category = 'Sensors'},
{combos = {{key = ';', reformers = {'RShift'}}}, pressed = iCommandSelecterUp, up = iCommandSelecterStop, name = 'Scan Zone Up', category = 'Sensors'},
{combos = {{key = '.', reformers = {'RShift'}}}, pressed = iCommandSelecterDown, up = iCommandSelecterStop, name = 'Scan Zone Down', category = 'Sensors'},
{combos = {{key = ',', reformers = {'RShift'}}}, pressed = iCommandSelecterLeft, up = iCommandSelecterStop, name = 'Scan Zone Left', category = 'Sensors'},
{combos = {{key = '/', reformers = {'RShift'}}}, pressed = iCommandSelecterRight, up = iCommandSelecterStop, name = 'Scan Zone Right', category = 'Sensors'},
{combos = {{key = '='}}, down = iCommandPlaneZoomIn, name = 'Display Zoom In', category = 'Sensors'},
{combos = {{key = '-'}}, down = iCommandPlaneZoomOut, name = 'Display Zoom Out', category = 'Sensors'},
{combos = {{key = 'W', reformers = {'LAlt'}}}, down = iCommandPlaneLaunchPermissionOverride, name = 'Launch Permission Override', category = 'Sensors'},
{combos = {{key = '-', reformers = {'RCtrl'}}}, down = iCommandDecreaseRadarScanArea, name = 'Decrease Radar Scan Limit', category = 'Sensors'},
{combos = {{key = '=', reformers = {'RCtrl'}}}, down = iCommandIncreaseRadarScanArea, name = 'Increase Radar Scan Limit', category = 'Sensors'},
{combos = {{key = '=', reformers = {'RAlt'}}}, pressed = iCommandPlaneIncreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = 'Increase Target Specified Size', category = 'Sensors'},
{combos = {{key = '-', reformers = {'RAlt'}}}, pressed = iCommandPlaneDecreaseBase_Distance, up = iCommandPlaneStopBase_Distance, name = 'Decrease Target Specified Size', category = 'Sensors'},
{combos = {{key = 'R', reformers = {'RShift'}}}, down = iCommandChangeRWRMode, name = 'Change RWR/SPO Mode', category = 'Sensors'},
{combos = {{key = ',', reformers = {'RAlt'}}}, down = iCommandPlaneThreatWarnSoundVolumeDown, name = 'RWR/SPO Sound Signals Volume Down', category = 'Sensors'},
{combos = {{key = '.', reformers = {'RAlt'}}}, down = iCommandPlaneThreatWarnSoundVolumeUp, name = 'RWR/SPO Sound Signals Volume Up', category = 'Sensors'},

-- Weapons                                                                        
{combos = {{key = 'Space'}}, down = iCommandPlaneFire, up = iCommandPlaneFireOff, name = 'Fire', category = 'Weapons'},
{combos = {{key = 'D'}}, down = iCommandPlaneChangeWeapon, name = 'Change Weapon', category = 'Weapons'},
{combos = {{key = 'C'}}, down = iCommandPlaneModeCannon, name = 'Toggle Cannon', category = 'Weapons'},
{combos = {{key = 'V', reformers = {'LCtrl'}}}, down = iCommandPlaneSalvoOnOff, name = 'Toggle Salvo Mode', category = 'Weapons'},
{combos = {{key = 'Enter'}}, down = iCommandPlanePickleOn,  up = iCommandPlanePickleOff, name = 'Release Weapon', category = 'Weapons'},
{combos = {{key = 'C', reformers = {'LShift'}}}, down = iCommandChangeGunRateOfFire, name = 'Change The Cannon Rate Of Fire / Cut Of Burst', category = 'Weapons'},
{combos = {{key = 'Space', reformers = {'LCtrl'}}}, down = iCommandChangeRippleQuantity, name = 'Change Ripple Quantity (A10/SU25/SU25T)', category = 'Weapons'},
{combos = {{key = 'V'}}, down = iCommandChangeRippleInterval, name = 'Increase Ripple Interval (A10/SU25/SU25T)', category = 'Weapons'},
{combos = {{key = 'V', reformers = {'LShift'}}}, down = iCommandChangeRippleIntervalDown, name = 'Decrease Ripple Interval (A10/SU25/SU25T)', category = 'Weapons'},
{combos = {{key = 'Space', reformers = {'LShift'}}}, down = iCommandChangeReleaseMode, name = 'Cycle PRS/SGL Release Submodes (A10)', category = 'Weapons'},

-- Countermeasures
{combos = {{key = 'Q', reformers = {'LShift'}}}, down = iCommandPlaneDropSnar, name = 'Continuously Dispense Chaff And Flares', category = 'Countermeasures'},
{combos = {{key = 'Q'}}, down = iCommandPlaneDropSnarOnce, up = iCommandPlaneDropSnarOnceOff, name = 'Dispense Chaff And Flares', category = 'Countermeasures'},
{combos = {{key = 'Delete'}}, down = iCommandPlaneDropFlareOnce, name = 'Dispense Flares', category = 'Countermeasures'},
{combos = {{key = 'Insert'}}, down = iCommandPlaneDropChaffOnce, name = 'Dispense Chaff', category = 'Countermeasures'},
{combos = {{key = 'E'}}, down = iCommandActiveJamming, name = 'Toggle ECM', category = 'Countermeasures'},
{combos = {{key = 'E', reformers = {'LShift'}}}, down = iCommandActiveIRJamming, name = 'Toggle Active IR Jamming', category = 'Countermeasures'},
--]]

-- Communications
-- {combos = {{key = 'E', reformers = {'LWin'}}}, down = iCommandPlaneDoAndHome, name = 'Dispatch wingmans - complete mission and RTB', category = 'Communications'},
-- {combos = {{key = 'R', reformers = {'LWin'}}}, down = iCommandPlaneDoAndBack, name = 'Dispatch wingmans - complete mission and rejoin', category = 'Communications'},
-- {combos = {{key = 'T', reformers = {'LWin'}}}, down = iCommandPlaneFormation, name = 'Toggle formation', category = 'Communications'},
-- {combos = {{key = 'Y', reformers = {'LWin'}}}, down = iCommandPlaneJoinUp, name = 'Join up formation', category = 'Communications'},
-- {combos = {{key = 'Q', reformers = {'LWin'}}}, down = iCommandPlaneAttackMyTarget, name = 'Attack my target', category = 'Communications'},
-- {combos = {{key = 'W', reformers = {'LWin'}}}, down = iCommandPlaneCoverMySix, name = 'Cover me', category = 'Communications'},
-- {combos = {{key = 'U', reformers = {'LWin'}}}, down = iCommandAWACSHomeBearing, name = 'Ask AWACS home airbase', category = 'Communications'},
-- {combos = {{key = 'I', reformers = {'LWin'}}}, down = iCommandAWACSTankerBearing, name = 'Ask AWACS available tanker', category = 'Communications'},
-- {combos = {{key = 'G', registers = {'LWin'}}}, down = iCommandPlane_EngageGroundTargets, name = 'Attack Ground Targets', category = 'Communications'},
-- {combos = {{key = 'D', registers = {'LWin'}}}, down = iCommandPlane_EngageAirDefenses, name = 'Attack Air Defenses', category = 'Communications'},
{combos = {{key = '\\'}}, down = iCommandToggleCommandMenu, name = 'Communication menu', category = 'Communications'},
{combos = {{key = '\\', reformers = {'LShift'}}}, down = ICommandSwitchDialog, name = 'Switch dialog', category = 'Communications'},

-- View                                                    
{combos = {{key = 'Num4'}}, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = 'View Left slow', category = 'View'},
{combos = {{key = 'Num6'}}, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = 'View Right slow', category = 'View'},
{combos = {{key = 'Num8'}}, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = 'View Up slow', category = 'View'},
{combos = {{key = 'Num2'}}, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = 'View Down slow', category = 'View'},
{combos = {{key = 'Num9'}}, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = 'View Up Right slow', category = 'View'},
{combos = {{key = 'Num3'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = 'View Down Right slow', category = 'View'},
{combos = {{key = 'Num1'}}, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = 'View Down Left slow', category = 'View'},
{combos = {{key = 'Num7'}}, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = 'View Up Left slow', category = 'View'},
{combos = {{key = 'Num5'}}, pressed = iCommandViewCenter, name = 'View Center', category = 'View'},

{combos = {{key = 'Num8', reformers = {'RShift'}}}, pressed = iCommandViewUp, up = iCommandViewStop, name = 'View up', category = 'View'},
{combos = {{key = 'Num2', reformers = {'RShift'}}}, pressed = iCommandViewDown, up = iCommandViewStop, name = 'View down', category = 'View'},
{combos = {{key = 'Num4', reformers = {'RShift'}}}, pressed = iCommandViewLeft, up = iCommandViewStop, name = 'View left', category = 'View'},
{combos = {{key = 'Num6', reformers = {'RShift'}}}, pressed = iCommandViewRight, up = iCommandViewStop, name = 'View right', category = 'View'},
{combos = {{key = 'Num9', reformers = {'RShift'}}}, pressed = iCommandViewUpRight, up = iCommandViewStop, name = 'View up right', category = 'View'},
{combos = {{key = 'Num3', reformers = {'RShift'}}}, pressed = iCommandViewDownRight, up = iCommandViewStop, name = 'View down right', category = 'View'},
{combos = {{key = 'Num1', reformers = {'RShift'}}}, pressed = iCommandViewDownLeft, up = iCommandViewStop, name = 'View down left', category = 'View'},
{combos = {{key = 'Num7', reformers = {'RShift'}}}, pressed = iCommandViewUpLeft, up = iCommandViewStop, name = 'View up left', category = 'View'},
{combos = {{key = 'Num*', reformers = {'RShift'}}}, pressed = iCommandViewForward, up = iCommandViewForwardStop, name = 'Zoom in', category = 'View'},
{combos = {{key = 'Num/', reformers = {'RShift'}}}, pressed = iCommandViewBack, up = iCommandViewBackStop, name = 'Zoom out', category = 'View'},

{combos = {{key = 'Num*'}}, pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = 'Zoom in slow', category = 'View'},
{combos = {{key = 'Num/'}}, pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = 'Zoom out slow', category = 'View'},
{combos = {{key = 'NumEnter'}}, down = iCommandViewAngleDefault, name = 'Zoom normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'RCtrl'}}}, pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = 'Zoom external in', category = 'View'},
{combos = {{key = 'Num/', reformers = {'RCtrl'}}}, pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = 'Zoom external out', category = 'View'},
{combos = {{key = 'NumEnter', reformers = {'RCtrl'}}}, down = iCommandViewExternalZoomDefault, name = 'Zoom external normal', category = 'View'},
{combos = {{key = 'Num*', reformers = {'LAlt'}}}, down = iCommandViewSpeedUp, name = 'F11 camera moving forward', category = 'View'},
{combos = {{key = 'Num/', reformers = {'LAlt'}}}, down = iCommandViewSlowDown, name = 'F11 camera moving backward', category = 'View'},


{combos = {{key = 'F1'}}, down = iCommandViewCockpit, name = 'F1 Cockpit view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LCtrl'}}}, down = iCommandNaturalViewCockpitIn, name = 'F1 Natural head movement view', category = 'View'},
{combos = {{key = 'F1', reformers = {'LAlt'}}}, down = iCommandViewHUDOnlyOnOff, name = 'F1 HUD only view switch', category = 'View'},
{combos = {{key = 'F2'}}, down = iCommandViewAir, name = 'F2 Aircraft view', category = 'View'},
{combos = {{key = 'F2', reformers = {'LCtrl'}}}, down = iCommandViewMe, name = 'F2 View own aircraft', category = 'View'},
{combos = {{key = 'F2', reformers = {'RAlt'}}}, down = iCommandViewFromTo, name = 'F2 Toggle camera position', category = 'View'},
{combos = {{key = 'F2', reformers = {'LAlt'}}}, down = iCommandViewLocal, name = 'F2 Toggle local camera control', category = 'View'},
{combos = {{key = 'F3'}}, down = iCommandViewTower, name = 'F3 Fly-By view', category = 'View'},
{combos = {{key = 'F3', reformers = {'LCtrl'}}}, down = iCommandViewTowerJump, name = 'F3 Fly-By jump view', category = 'View'},
{combos = {{key = 'F4'}}, down = iCommandViewRear, name = 'F4 Look back view', category = 'View'},
{combos = {{key = 'F4', reformers = {'LCtrl'}}}, down = iCommandViewChase, name = 'F4 Chase view', category = 'View'},
{combos = {{key = 'F5'}}, down = iCommandViewFight, name = 'F5 nearest AC view', category = 'View'},
{combos = {{key = 'F5', reformers = {'LCtrl'}}}, down = iCommandViewFightGround, name = 'F5 Ground hostile view', category = 'View'},
{combos = {{key = 'F6'}}, down = iCommandViewWeapons, name = 'F6 Released weapon view', category = 'View'},
{combos = {{key = 'F6', reformers = {'LCtrl'}}}, down = iCommandViewWeaponAndTarget, name = 'F6 Weapon to target view', category = 'View'},
{combos = {{key = 'F7'}}, down = iCommandViewGround, name = 'F7 Ground unit view', category = 'View'},
{combos = {{key = 'F7', reformers = {'LCtrl'}}}, down = iCommandViewJFO, name = 'F7 Ground JFO/JTAC view', category = 'View'},
{combos = {{key = 'F8'}}, down = iCommandViewTargets, name = 'F8 Target view', category = 'View'},
{combos = {{key = 'F8', reformers = {'RAlt'}}}, down = iCommandViewTargetType, name = 'F8 Player targets/All targets filter', category = 'View'},
{combos = {{key = 'F9'}}, down = iCommandViewNavy, name = 'F9 Ship view', category = 'View'},
{combos = {{key = 'F9', reformers = {'LAlt'}}}, down = iCommandViewLndgOfficer, name = 'F9 Landing signal officer view', category = 'View'},
{combos = {{key = 'F10'}}, down = iCommandViewAWACS, name = 'F10 Theater map view', category = 'View'},
{combos = {{key = 'F10', reformers = {'LCtrl'}}}, down = iCommandViewAWACSJump, name = 'F10 Jump to theater map view over current point', category = 'View'},
{combos = {{key = 'F11'}}, down = iCommandViewFree, name = 'F11 Airport free camera', category = 'View'},
{combos = {{key = 'F11', reformers = {'LCtrl'}}}, down = iCommandViewFreeJump, name = 'F11 Jump to free camera', category = 'View'},
{combos = {{key = 'F12'}}, down = iCommandViewStatic, name = 'F12 Static object view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LCtrl'}}}, down = iCommandViewMirage, name = 'F12 Civil traffic view', category = 'View'},
{combos = {{key = 'F12', reformers = {'LShift'}}}, down = iCommandViewLocomotivesToggle, name = 'F12 Trains/cars toggle', category = 'View'},
{combos = {{key = 'F1', reformers = {'LWin'}}} , down = iCommandViewPitHeadOnOff, name = 'F1 Head shift movement on / off', category = 'View'},

{combos = {{key = ']', reformers = {'LShift'}}}, down = iCommandViewFastKeyboard, name = 'Fast keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LCtrl'}}}, down = iCommandViewSlowKeyboard, name = 'Slow keyboard turn speed', category = 'View'},
{combos = {{key = ']', reformers = {'LAlt'}}}, down = iCommandViewNormalKeyboard, name = 'Normal keyboard turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LShift'}}}, down =  iCommandViewFastMouse, name = 'Fast mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LCtrl'}}}, down = iCommandViewSlowMouse, name = 'Slow mouse turn speed', category = 'View'},
{combos = {{key = '[', reformers = {'LAlt'}}}, down = iCommandViewNormalMouse, name = 'Normal mouse turn speed', category = 'View'},

--[[
-- Cockpit view
{combos = {{key = 'Num0'}}, down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = 'Cockpit panel view in', category = 'View Cockpit'},
{combos = {{key = 'Num0', reformers = {'RCtrl'}}}, down = iCommandViewTempCockpitToggle, name = 'Cockpit panel view toggle', category = 'View Cockpit'},
--// Save current cockpit camera angles for fast numpad jumps  
{combos = {{key = 'Num0', reformers = {'RAlt'}}}, down = iCommandViewSaveAngles, name = 'Save Cockpit Angles', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RCtrl'}}}, down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = 'Camera view up', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RCtrl'}}}, down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = 'Camera view down', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RCtrl'}}}, down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = 'Camera view left', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RCtrl'}}}, down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = 'Camera view right', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RCtrl'}}}, down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = 'Camera view up-left', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RCtrl'}}}, down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = 'Camera view down-left', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RCtrl'}}}, down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = 'Camera view up-right', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RCtrl'}}}, down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = 'Camera view down-right', category = 'View Cockpit'},
{combos = {{key = 'Z', reformers = {'LAlt'}}}, down = iCommandViewPanToggle, name = 'Camera pan mode toggle', category = 'View Cockpit'},

{combos = {{key = 'Num8', reformers = {'RAlt'}}}, down = iCommandViewCameraUpSlow, name = 'Camera view up slow', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'RAlt'}}}, down = iCommandViewCameraDownSlow, name = 'Camera view down slow', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'RAlt'}}}, down = iCommandViewCameraLeftSlow, name = 'Camera view left slow', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'RAlt'}}}, down = iCommandViewCameraRightSlow, name = 'Camera view right slow', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'RAlt'}}}, down = iCommandViewCameraUpLeftSlow, name = 'Camera view up-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'RAlt'}}}, down = iCommandViewCameraDownLeftSlow, name = 'Camera view down-left slow', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'RAlt'}}}, down = iCommandViewCameraDownRight, name = 'Camera view up-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'RAlt'}}}, down = iCommandViewCameraUpRightSlow, name = 'Camera view down-right slow', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RShift'}}}, down = iCommandViewCameraCenter, name = 'Center camera view', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RCtrl'}}}, down = iCommandViewCameraReturn, name = 'Return camera', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'RAlt'}}}, down = iCommandViewCameraBaseReturn, name = 'Return camera base', category = 'View Cockpit'},

{combos = {{key = 'Num0', reformers = {'LWin'}}}, down = iCommandViewSnapView0, up = iCommandViewSnapViewStop, name = 'Snap View 0', category = 'View Cockpit'},
{combos = {{key = 'Num1', reformers = {'LWin'}}}, down = iCommandViewSnapView1, up = iCommandViewSnapViewStop, name = 'Snap View 1', category = 'View Cockpit'},
{combos = {{key = 'Num2', reformers = {'LWin'}}}, down = iCommandViewSnapView2, up = iCommandViewSnapViewStop, name = 'Snap View 2', category = 'View Cockpit'},
{combos = {{key = 'Num3', reformers = {'LWin'}}}, down = iCommandViewSnapView3, up = iCommandViewSnapViewStop, name = 'Snap View 3', category = 'View Cockpit'},
{combos = {{key = 'Num4', reformers = {'LWin'}}}, down = iCommandViewSnapView4, up = iCommandViewSnapViewStop, name = 'Snap View 4', category = 'View Cockpit'},
{combos = {{key = 'Num5', reformers = {'LWin'}}}, down = iCommandViewSnapView5, up = iCommandViewSnapViewStop, name = 'Snap View 5', category = 'View Cockpit'},
{combos = {{key = 'Num6', reformers = {'LWin'}}}, down = iCommandViewSnapView6, up = iCommandViewSnapViewStop, name = 'Snap View 6', category = 'View Cockpit'},
{combos = {{key = 'Num7', reformers = {'LWin'}}}, down = iCommandViewSnapView7, up = iCommandViewSnapViewStop, name = 'Snap View 7', category = 'View Cockpit'},
{combos = {{key = 'Num8', reformers = {'LWin'}}}, down = iCommandViewSnapView8, up = iCommandViewSnapViewStop, name = 'Snap View 8', category = 'View Cockpit'},
{combos = {{key = 'Num9', reformers = {'LWin'}}}, down = iCommandViewSnapView9, up = iCommandViewSnapViewStop, name = 'Snap View 9', category = 'View Cockpit'},

{combos = {{key = 'N', reformers = {'RWin'}}}, down = iCommandViewLeftMirrorOn ,    up = iCommandViewLeftMirrorOff , name = 'Left Mirror On', category = 'View Cockpit'},
{combos = {{key = 'M', reformers = {'RWin'}}}, down = iCommandViewRightMirrorOn,    up = iCommandViewRightMirrorOff, name = 'Right Mirror On', category = 'View Cockpit'},
]]

-- Extended view
{combos = {{key = 'J', reformers = {'LShift'}}}, down = iCommandViewCameraJiggle, name = 'Camera jiggle toggle', category = 'View Extended'},
{combos = {{key = 'K', reformers = {'LAlt'}}}, down = iCommandViewKeepTerrain, name = 'Keep terrain camera altitude', category = 'View Extended'},
{combos = {{key = 'Home', reformers = {'RCtrl'}}}, down = iCommandViewFriends, name = 'View friends mode', category = 'View Extended'},
{combos = {{key = 'End', reformers = {'RCtrl'}}}, down = iCommandViewEnemies, name = 'View enemies mode', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'RCtrl'}}}, down = iCommandViewAll, name = 'View all mode', category = 'View Extended'},
{combos = {{key = 'Num+', reformers = {'RCtrl'}}}, down = iCommandViewPlus, name = 'Toggle tracking fire weapon', category = 'View Extended'},
{combos = {{key = 'PageDown', reformers = {'LCtrl'}}}, down = iCommandViewSwitchForward, name = 'Objects switching direction forward ', category = 'View Extended'},
{combos = {{key = 'PageUp', reformers = {'LCtrl'}}}, down = iCommandViewSwitchReverse, name = 'Objects switching direction reverse ', category = 'View Extended'},
{combos = {{key = 'Delete', reformers = {'LAlt'}}}, down = iCommandViewObjectIgnore, name = 'Object exclude ', category = 'View Extended'},
{combos = {{key = 'Insert', reformers = {'LAlt'}}}, down = iCommandViewObjectsAll, name = 'Objects all excluded - include', category = 'View Extended'},

-- Padlock

{combos = {{key = 'Num.'}}, down = iCommandViewLock, name = 'Lock view (cycle padlock)', category = 'View Padlock'},
{combos = {{key = 'NumLock'}}, down = iCommandViewUnlock, name = 'Unlock view (stop padlock)', category = 'View Padlock'},
--{combos = {{key = 'Num.', reformers = {'RShift'}}}, down = iCommandAllMissilePadlock, name = 'All missiles padlock', category = 'View Padlock'},
--{combos = {{key = 'Num.', reformers = {'RAlt'}}}, down = iCommandThreatMissilePadlock, name = 'Threat missile padlock', category = 'View Padlock'},
{combos = {{key = 'Num.', reformers = {'RCtrl'}}}, down = iCommandViewTerrainLock, name = 'Lock terrain view', category = 'View Padlock'},


-- Labels
{combos = {{key = 'F10', reformers = {'LShift'}}}, down = iCommandMarkerState, name = 'All Labels', category = 'Labels'},
{combos = {{key = 'F2', reformers = {'LShift'}}}, down = iCommandMarkerStatePlane, name = 'Aircraft Labels', category = 'Labels'},
{combos = {{key = 'F6', reformers = {'LShift'}}}, down = iCommandMarkerStateRocket, name = 'Missile Labels', category = 'Labels'},
{combos = {{key = 'F9', reformers = {'LShift'}}}, down = iCommandMarkerStateShip, name = 'Vehicle & Ship Labels', category = 'Labels'},
--[[
--Debug view (10000 - 10050)
{combos = {{key = 'D', reformers = {'LCtrl', 'LShift'}}}, down = 10000, name = 'Object debug info on/off', category = 'Debug'},
{combos = {{key = 'T', reformers = {'LCtrl', 'LShift'}}}, down = 10001, name = 'Object debug text on/off', category = 'Debug'},
{combos = {{key = 'G', reformers = {'LCtrl', 'LShift'}}}, down = 10002, name = 'Object debug geometry on/off', category = 'Debug'},

--AI debug (10051 - 100100)
--Info (10051 - 10071)
{combos = {{key = 'I', reformers = {'LCtrl', 'LShift'}}}, down = 10052, name = 'Assign target of interest', category = 'AI debug'},
{combos = {{key = 'R', reformers = {'LCtrl', 'LShift'}}}, down = 10053, name = 'Reset target of interest', category = 'AI debug'},
{combos = {{key = 'C', reformers = {'LCtrl', 'LShift'}}}, down = 10054, name = 'Assign current target as target of interest', category = 'AI debug'},
--Commands(10051 - 10100)
{combos = {{key = 'A', reformers = {'LCtrl', 'LShift'}}}, down = 10100, name = 'Attack target', category = 'AI debug'},
]]
-- Auto Lock On 
--[[
{combos = {{key = 'F5', reformers = {'RWin'}}}, down = iCommandAutoLockOnNearestAircraft, name = 'Auto lock on nearest aircraft', category = 'Simplifications'},
{combos = {{key = 'F6', reformers = {'RWin'}}}, down = iCommandAutoLockOnCenterAircraft, name = 'Auto lock on center aircraft', category = 'Simplifications'},
{combos = {{key = 'F7', reformers = {'RWin'}}}, down = iCommandAutoLockOnNextAircraft, name = 'Auto lock on next aircraft', category = 'Simplifications'},
{combos = {{key = 'F8', reformers = {'RWin'}}}, down = iCommandAutoLockOnPreviousAircraft, name = 'Auto lock on previous aircraft', category = 'Simplifications'},
{combos = {{key = 'F9', reformers = {'RWin'}}}, down = iCommandAutoLockOnNearestSurfaceTarget, name = 'Auto lock on nearest surface target', category = 'Simplifications'},
{combos = {{key = 'F10', reformers = {'RWin'}}}, down = iCommandAutoLockOnCenterSurfaceTarget, name = 'Auto lock on center surface target', category = 'Simplifications'},
{combos = {{key = 'F11', reformers = {'RWin'}}}, down = iCommandAutoLockOnNextSurfaceTarget, name = 'Auto lock on next surface target', category = 'Simplifications'},
{combos = {{key = 'F12', reformers = {'RWin'}}}, down = iCommandAutoLockOnPreviousSurfaceTarget, name = 'Auto lock on previous surface target', category = 'Simplifications'},
--]]

--//      (  )
--//iCommandRollbackSave,   "Create rollback point",                        1, CONTROL, KEY_O,  CUSTOM_FOLDER,
--//     
--//iCommandRollBack,       "Return to previous rollback point",            1, ALT,     KEY_O,  CUSTOM_FOLDER,
--//     
--//iCommandRollForward,    "Jump to next rollback point",                  1, SHIFT,   KEY_O,  CUSTOM_FOLDER,
--// /     


--{combos = {{key = 'C'}}, down = iCommandCockpitClickModeOnOff, name = 'Clickable Mouse Cockpit Mode On/Off', category = 'Flight Control'},
--//iCommandCockpitClickOn,          "Clickable cockpit action on"        , 1, RWIN, 0,                 Flight Control_FOLDER,      //      
--//iCommandCockpitClickOff,         "Clickable cockpit action off"       , 0, RWIN, 0,                 Flight Control_FOLDER ,     //       
--//iCommandCockpitSecondClickOn,    "Clickable cockpit action on(secondary)" , 1,  LWIN, 0,            Flight Control_FOLDER,      //      
--//iCommandCockpitSecondClickOff,   "Clickable cockpit action off(secondary)", 0,  LWIN, 0,            Flight Control_FOLDER ,     //       


-- //iCommandAutomaticSpinRecovery, "Toggle automatic spin recovery",        1, ALT,     KEY_P,  Flight Control_FOLDER,
-- //iCommandSpeedRetention,     "Toggle speed retention",                   1, ALT,     KEY_S,  Flight Control_FOLDER,
-- //iCommandEasyLanding,        "Toggle easy landing",                      1, ALT,     KEY_E,  Flight Control_FOLDER,

-- FAC
-- {combos = {{key = 'B', reformers = {'LWin'}}}, down = iCommandViewBinocular, name = 'Binocular view toggle', category = 'FAC'},
-- {combos = {{key = 'L', reformers = {'LWin'}}}, down = iCommandViewLaserOnOff, name = 'Binocular laser illumination toggle', category = 'FAC'},
-- {combos = {{key = 'Z', reformers = {'LWin'}}}, down = iCommandViewIR, name = 'Binocular view IR mode', category = 'FAC'},

-- /*
-- iCommandViewRangeFinderOn,   "Binocular range-finder on",                1, RWIN, KEY_R,         VIEW_FOLDER,            
-- iCommandViewRangeFinderOff,  "Binocular range-finder off",               0, RWIN, KEY_R,         VIEW_FOLDER,            
-- */
--{combos = {{key = 'C', 'LWin'}}}, down = iCommandCompassRose, name = 'Cockpit compass rose', category = 'View'},


},
}
end
